#!/bin/sh
#SBATCH --job-name="RLCapstone1"
#SBATCH --partition=gpu
#SBATCH --time=12:00:00
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=2
#SBATCH --gpus-per-node=1
#SBATCH --mem-per-cpu=3G
#SBATCH --output=outputfile1.txt
#SBATCH --error=errorfile1.txt

module load 2022r2
module load cuda/11.6
module load python/3.8.12
module load py-pip
module load git
module load openssh

python -m pip install --user opencv-python
python -m pip install --user gym==0.26.2
python -m pip install --user "/scratch/jjvandeweg/highway-env-master/"
python -m pip install --user stable-baselines3
python -m pip install --user git+https://github.com/carlosluis/stable-baselines3@fix_tests
python -m pip install --user git+https://github.com/Stable-Baselines-Team/stable-baselines3-contrib
python -m pip install --user tensorboard
python -m pip install --user scipy
python -m pip install --user torch
python -m pip install --user numpy==1.23.4
python -m pip install --user torch==1.13.0

cd /scratch/jjvandeweg/
srun python main_mid.py